/**
 * \file: mspin_demo_iap2_configuration_pfcfg.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin
 *
 * \component: MSPIN
 *
 * \author: Bui Le Thuan / thuan.buile@vn.bosch.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 *
 ***********************************************************************/


#include <adit_typedef.h>
#include "pfcfg_interface.h"
#include "iap2_defines.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "mspin_demo_iap2_configuration_pfcfg.h"


S32 Iap2ConfigurationPfcfg::iAP2TestGetDevConfNumParam(VP IAP2TEST_Cfg_FileName, U32 i, IAP2TEST_Cfg* p_iAP2TestCfg)
{
    S32 rc = 1;

    rc = iAP2Test_util_bGetCfn(IAP2TEST_Cfg_FileName,
            (S8*)(VP) p_iAP2TestCfg[i].name, &p_iAP2TestCfg[i].para.val);
    if (rc <= 0)
    {
        rc = IAP2_ERR_ABORT;
    }

    return rc;
}

S32 Iap2ConfigurationPfcfg::iAP2TestGetDevConfStrParam(VP IAP2TEST_Cfg_FileName, U32 i, IAP2TEST_Cfg* p_iAP2TestCfg)
{
    S32 rc = 1;
    U8 str[IAP2_CFG_STR_MAX] = { 0 };

    rc = iAP2Test_util_bGetCfs(IAP2TEST_Cfg_FileName,
            (S8*)(VP) p_iAP2TestCfg[i].name, (char*)(VP) str, IAP2_CFG_STR_MAX);
    if (rc > 0)
    {
        p_iAP2TestCfg[i].para.p_val = (U8*)calloc((U32) IAP2_CFG_STR_MAX, sizeof(U8));
        if (p_iAP2TestCfg[i].para.p_val != NULL)
        {
            strncpy((char*)(VP) p_iAP2TestCfg[i].para.p_val, (char*)(VP) str, IAP2_CFG_STR_MAX);
            p_iAP2TestCfg[i].para.p_val[IAP2_CFG_STR_MAX - 1] = '\0';
        }
        else
        {
            rc = IAP2_ERR_ABORT;
        }
    }
    else
    {
        rc = IAP2_ERR_ABORT;
    }

    return rc;
}

IAP2TEST_Cfg * Iap2ConfigurationPfcfg::iAP2TestGetDevconfParameter(U8* num_cfg)
{
    S32 rc = 1;
    U32 i = 0;
    VP IAP2TEST_Cfg_FileName;
    IAP2TEST_Cfg *p_iAP2TestCfg = NULL;
    IAP2TEST_Cfg iAP2TestCfg[] =
    {
       {(U8 *)IPOD_AUTH_DEV_NAME,              FALSE,    {0}},
       {(U8 *)IPOD_AUTH_IOCTL_REG,             FALSE,    {0}},
       {(U8 *)IPOD_AUTH_GPIO_RESET,            FALSE,    {0}},
       {(U8 *)IPOD_AUTH_GPIO_READY,            FALSE,    {0}},
       {(U8 *)IPOD_AUTH_DEV_COM_SHORT_WAIT,    TRUE,     {0}},
       {(U8 *)IPOD_AUTH_DEV_COM_WAIT,          TRUE,     {0}},
       {(U8 *)IPOD_AUTH_DEV_COM_LONG_WAIT,     TRUE,     {0}},
    };

    *num_cfg = sizeof(iAP2TestCfg)/sizeof(IAP2TEST_Cfg);
    p_iAP2TestCfg = (IAP2TEST_Cfg *)calloc((*num_cfg), sizeof(IAP2TEST_Cfg));
    memcpy(p_iAP2TestCfg, iAP2TestCfg, (*num_cfg)*sizeof(IAP2TEST_Cfg));

    IAP2TEST_Cfg_FileName = PFCFG_opn_cnf(IAP2_AUTH_CONFIGURATION_FILE, PFCFG_READ);
    if (IAP2TEST_Cfg_FileName != NULL)
    {
        for (i = 0; ((i < (*num_cfg)) && (rc > IAP2_OK)); i++)
        {
            if (iAP2TestCfg[i].isInt != FALSE)
            {
                rc = iAP2TestGetDevConfNumParam(IAP2TEST_Cfg_FileName, i, p_iAP2TestCfg);
            }
            else
            {
                rc = iAP2TestGetDevConfStrParam(IAP2TEST_Cfg_FileName, i, p_iAP2TestCfg);
            }
        }
        PFCFG_close_cnf((PFCFG_Handle_t*)IAP2TEST_Cfg_FileName);
        if (rc > 0)
        {
            rc = IAP2_OK;
        }
        else
        {
            iAP2TestFreeDevconfParameter(p_iAP2TestCfg, *num_cfg);
            p_iAP2TestCfg = NULL;
        }
    }
    else
    {
        rc = IAP2_ERR_ABORT;
    }
    return p_iAP2TestCfg;

}

void Iap2ConfigurationPfcfg::iAP2TestFreeDevconfParameter(IAP2TEST_Cfg *p_iAP2TestCfg, U8 num_cfg)
{
    S32 i = 0;

    for(i = 0; i < num_cfg; i++)
    {
        if (p_iAP2TestCfg[i].isInt == FALSE)
        {
            free(p_iAP2TestCfg[i].para.p_val);
            p_iAP2TestCfg[i].para.p_val = NULL;
        }
    }

    free(p_iAP2TestCfg);
    p_iAP2TestCfg = NULL;
}

S32 Iap2ConfigurationPfcfg::iAP2Test_util_bGetCfn(VP IAP2TEST_Cfg_FileName, S8 *identifier,
                             S32 *int_value)
{
    S32 err = IAP2_OK;
    PFCFG_ERR retval = PFCFG_get_cfn((PFCFG_Handle_t*)IAP2TEST_Cfg_FileName, (const PFCFG_CHAR*)(VP) identifier,
            int_value, IAP2_CFG_NUM_LENGTH);

    if (retval >= PFCFG_NO_ERROR)
    {
        err = retval;
    }
    else
    {
        err = IAP2_ERR_ABORT;
    }

    return err;
}

S32 Iap2ConfigurationPfcfg::iAP2Test_util_bGetCfs(VP IAP2TEST_Cfg_FileName, S8  *identifier,
                             char *str_value,
                             U32 size)
{
    S32 err = IAP2_OK;

    PFCFG_ERR retval = PFCFG_get_cfs((PFCFG_Handle_t*)IAP2TEST_Cfg_FileName, (const PFCFG_CHAR*)(VP) identifier,
            str_value, (S32) size);

    if (retval == PFCFG_NO_ERROR)
    {
        err = strlen(str_value);
    }
    else
    {
        err = IAP2_ERR_ABORT;
    }

    return err;
}

